<?php
/**
 * Uninstall handler.
 *
 * @package Performant_Translations
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	return;
}

$locations = array(
	WP_LANG_DIR,
	WP_LANG_DIR . '/plugins',
	WP_LANG_DIR . '/themes',
);

$locale = get_locale();

$is_wordpress_65 = class_exists( 'WP_Translation_Controller' );

foreach ( $locations as $location ) {
	// Delete all .mo.php files generated by the plugin,
	// plus all files using the old .php extension except
	// index.php and $locale.php IF not generated by the plugin.
	// See https://github.com/swissspidy/performant-translations/pull/84.
	$lang_files = glob( $location . '/*.php' );
	if ( $lang_files ) {
		foreach ( $lang_files as $lang_file ) {
			// Not something WordPress adds by default, but could exist.
			if ( 'index.php' === basename( $lang_file ) ) {
				continue;
			}

			// On WordPress 6.5, .l10n.php files are to be expected and should not be deleted.
			if ( $is_wordpress_65 && str_ends_with( $lang_file, '.l10n.php' ) ) {
				continue;
			}

			if ( "$locale.php" === basename( $lang_file ) ) {
				$fp            = fopen( $lang_file, 'r' );
				$file_contents = fread( $fp, 20 );

				$seems_like_translation_file = str_contains( $file_contents, 'return [' );

				fclose( $fp );

				if ( ! $seems_like_translation_file ) {
					continue;
				}
			}

			wp_delete_file( $lang_file );
		}
	}
}
