<?php 

/**
 * Template part for displaying post meta
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package eduker
 */

$categories = get_the_terms( $post->ID, 'category' );
$eduker_blog_date = get_theme_mod( 'eduker_blog_date', true );
$eduker_blog_comments = get_theme_mod( 'eduker_blog_comments', true );
$eduker_blog_author = get_theme_mod( 'eduker_blog_author', true );
$eduker_blog_cat = get_theme_mod( 'eduker_blog_cat', false );

?>


<div class="postbox__meta">
   

    <?php if ( !empty($eduker_blog_cat) ): ?>
    <?php if ( !empty( $categories[0]->name ) ): ?>  
    <span><i class="icon_tag_alt"></i> <a href="<?php print esc_url(get_category_link($categories[0]->term_id)); ?>"><?php echo esc_html($categories[0]->name); ?></a> </span>
    <?php endif;?>
    <?php endif;?>

    <?php if ( !empty($eduker_blog_date) ): ?>
    <span><i class="fal fa-calendar-check"></i> <?php the_time( get_option('date_format') ); ?> </span>
    <?php endif;?>

</div>