<?php 

	/**
	 * Template part for displaying header layout three
	 *
	 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
	 *
	 * @package eduker
	*/

   // info
   $eduker_topbar_switch = get_theme_mod( 'eduker_topbar_switch', false );
   $eduker_phone_num = get_theme_mod( 'eduker_phone_num', __( '+(088) 234 567 899', 'eduker' ) );
   $eduker_mail_id = get_theme_mod( 'eduker_mail_id', __( 'info@eduker.com', 'eduker' ) );
   $eduker_address = get_theme_mod( 'eduker_address', __( 'Moon ave, New York, 2020 NY US', 'eduker' ) );
   $eduker_address_url = get_theme_mod( 'eduker_address_url', __( 'https://goo.gl/maps/qzqY2PAcQwUz1BYN9', 'eduker' ) );

   // contact button
   $eduker_button_text = get_theme_mod( 'eduker_button_text', __( 'Contact Us', 'eduker' ) );
   $eduker_button_link = get_theme_mod( 'eduker_button_link', __( '#', 'eduker' ) );

   // acc button
   $eduker_acc_button_text = get_theme_mod( 'eduker_acc_button_text', __( 'Login', 'eduker' ) );
   $eduker_acc_button_link = get_theme_mod( 'eduker_acc_button_link', __( '#', 'eduker' ) );

   // header right
   $eduker_search = get_theme_mod( 'eduker_search', false );
   $eduker_header_right = get_theme_mod( 'eduker_header_right', false );
   $eduker_menu_col = $eduker_header_right ? 'col-xxl-7 col-xl-7 col-lg-8 d-none d-lg-block' : 'col-xxl-10 col-xl-10 col-lg-9 d-none d-lg-block text-end';

?>


<header id="header">
   <div class="header__area">
      <div class="header__bottom header__bottom-3">
         <div class="container">
            <div class="row align-items-center">
               <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6 col-6 d-none d-lg-block">
               <div class="footer__social footer__social-3">
                        <?php eduker_footer_social_profiles(); ?>
                     </div>
               </div>
               <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-6">
                 
               </div>
               <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-8 col-6">
               <div class="header__call d-flex align-items-center justify-content-end">
                  <div class="contact-icon">
							<i class="fa fa-phone"></i>
						</div>
                     <div class="header__call-content ">
                        <a href="tel:(+216) 27 451 533" class="contact-info">
                           <span class="text">Appelez nous</span> <br>
                           <span class="title">(+216) 27 451 533</span>
                        </a>
                     </div>
                  </div>
                  <div class="header__bottom-right d-flex justify-content-end align-items-center pl-30">
                     

                     <?php if ( !empty( $eduker_acc_button_link ) ): ?>
                     <div class="header__login-2 d-none d-md-flex align-items-center ml-20 pl-20">
                        <div class="header__login-icon mr-10">
                           <a href="sign-in.html">
                              <svg width="12" height="14" viewBox="0 0 12 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                 <path d="M5.99995 6.83333C7.61078 6.83333 8.91662 5.5275 8.91662 3.91667C8.91662 2.30584 7.61078 1 5.99995 1C4.38912 1 3.08328 2.30584 3.08328 3.91667C3.08328 5.5275 4.38912 6.83333 5.99995 6.83333Z" stroke="#031220" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"/>
                                 <path d="M11.0108 12.6667C11.0108 10.4092 8.76497 8.58333 5.99997 8.58333C3.23497 8.58333 0.989136 10.4092 0.989136 12.6667" stroke="#031220" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"/>
                              </svg>
                           </a>
                        </div>
                        <div class="header__login-content">
                           <p><a href="<?php echo esc_html($eduker_acc_button_link); ?>"><?php echo esc_html__('Login','eduker'); ?></a></p>
                           <p><a href="<?php echo esc_html($eduker_acc_button_link); ?>"><?php echo esc_html__('Register','eduker'); ?></a></p>
                        </div>
                     </div>
                    
                     <?php endif; ?>
                     <div class="header__hamburger ml-50">
                        <button type="button" data-bs-toggle="modal" data-bs-target="#offcanvasmodal" class="hamurger-btn" aria-label="canvas">
                           <span></span>
                           <span></span>
                           <span></span>
                        </button>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <div class="header__menu theme-bg-3 d-none d-lg-block">
         <div class="container">
            <div class="row align-items-center">
            <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-4">
                  <div class="logo ">
                     <?php eduker_header_logo();?>
                  </div>
               </div>
               <div class="col-xxl-6 col-xl-6 col-lg-6">
                  <div class="main-menu main-menu-3 d-flex align-items-right justify-content-end">
                     
                     <nav>
                        <?php eduker_header_menu();?>
                       
                     </nav>
                  </div>
               </div>
               <div class="col-xxl-2 col-xl-2 col-lg-2">
                  <div class="main-menu main-menu-3 d-flex align-items-right justify-content-end">
                        <p class="popupform" style="text-align: center;"><a href="https://formationcomptabilite.tn/?post_type=popup&amp;p=3421">Pré- Inscription</a></p>

                  </div>
               </div>
            </div>
         </div>
      </div>
</header>




<?php get_template_part( 'template-parts/header/header-side-info' ); ?>